TITLE   'Coin in a Metal Box, Improved'				{ 3d223a.pde }
SELECT     errlim=1e-3     ngrid=1    spectral_colors	
COORDINATES     cartesian3			{ Professional Edition }
VARIABLES     U		
DEFINITIONS
   L=0.05	    r0=0.01     d0=2e-3     U0=1.0
   Ex=-dx( U)     Ey=-dy( U)     Ez=-dz( U)
   E=-grad( U)     Em=magnitude( E)
EQUATIONS
   div( grad( U))=0
EXTRUSION						{ Parallel surfaces }
   surface 'bottom' z=-L	
   layer 'air 1'						{ Layer below coin }
   surface 'lower' z=-d0
   layer 'metal'						{ Layer containing coin }
   surface 'upper' z=d0
   layer 'air 2'						{ Layer above coin }
   surface 'top' z=L
BOUNDARIES
   surface 'bottom'  value( U)=0
   surface 'top'  value( U)=0
region 'domain'						{ Full solution domain }	
   start (-L,-L)  value( U)=0				{ For all four faces }
   line to (L,-L)  to (L,L)  to (-L,L)  close
limited region 'coin'						{ Exclude volume }						{ Exclude volume }
   surface 'lower' value( U)=U0
   surface 'upper' value( U)=U0
   layer 'metal' void						
   start (r0,0) layer 'metal' value( U)=U0		{ Coin }
   arc( center=0,0) angle=360
PLOTS
   grid(x,y,z)     grid(x,y) on z=L/2
   contour( U) painted on z=0     contour( U) painted on z=2*d0
   contour( U) painted on z=0.5*L     contour( U) painted on x=0
   vector( E) norm on z=0.5*L
   contour( Em) painted on x=0
   vector( E) norm on x=0
   elevation( U) from (-L,0,d0) to (L,0,d0)
END

END

